/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.lucene.ars_nouveau.facet.FacetsCollector;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.CollectorManager;
import org.apache.lucene.ars_nouveau.search.FieldDoc;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.MultiCollectorManager;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.ScoreDoc;
import org.apache.lucene.ars_nouveau.search.Sort;
import org.apache.lucene.ars_nouveau.search.TopDocs;
import org.apache.lucene.ars_nouveau.search.TopFieldCollector;
import org.apache.lucene.ars_nouveau.search.TopFieldCollectorManager;
import org.apache.lucene.ars_nouveau.search.TopScoreDocCollectorManager;
import org.apache.lucene.ars_nouveau.search.TotalHitCountCollectorManager;
import org.apache.lucene.ars_nouveau.search.TotalHits;
import org.apache.lucene.ars_nouveau.util.DocIdSetBuilder;

public class FacetsCollectorManager
implements CollectorManager<FacetsCollector, FacetsCollector> {
    private final boolean keepScores;

    public FacetsCollectorManager() {
        this(false);
    }

    public FacetsCollectorManager(boolean keepScores) {
        this.keepScores = keepScores;
    }

    @Override
    public FacetsCollector newCollector() throws IOException {
        return new FacetsCollector(this.keepScores);
    }

    @Override
    public FacetsCollector reduce(Collection<FacetsCollector> collectors) throws IOException {
        if (collectors == null || collectors.size() == 0) {
            return new FacetsCollector();
        }
        if (collectors.size() == 1) {
            return collectors.iterator().next();
        }
        assert (collectors.stream().allMatch(fc -> fc.getKeepScores() == this.keepScores));
        return new ReducedFacetsCollector(collectors, this.keepScores);
    }

    static Collection<FacetsCollector.MatchingDocs> reduceMatchingDocs(Collection<? extends FacetsCollector> facetsCollectors) {
        HashMap<LeafReaderContext, FacetsCollector.MatchingDocs> matchingDocsMap = new HashMap<LeafReaderContext, FacetsCollector.MatchingDocs>();
        for (FacetsCollector facetsCollector : facetsCollectors) {
            for (FacetsCollector.MatchingDocs matchingDocs : facetsCollector.getMatchingDocs()) {
                matchingDocsMap.compute(matchingDocs.context(), (leafReaderContext, existing) -> {
                    if (existing == null) {
                        return matchingDocs;
                    }
                    return FacetsCollectorManager.merge(existing, matchingDocs);
                });
            }
        }
        return matchingDocsMap.values();
    }

    private static FacetsCollector.MatchingDocs merge(FacetsCollector.MatchingDocs matchingDocs1, FacetsCollector.MatchingDocs matchingDocs2) {
        float[] scores;
        assert (matchingDocs1.context() == matchingDocs2.context());
        if (matchingDocs1.scores() == null && matchingDocs2.scores() == null) {
            scores = new float[]{};
        } else if (matchingDocs2.scores() == null) {
            scores = matchingDocs1.scores();
        } else if (matchingDocs1.scores() == null) {
            scores = matchingDocs2.scores();
        } else {
            int length = Math.max(matchingDocs1.scores().length, matchingDocs2.scores().length);
            scores = new float[length];
            for (int i = 0; i < length; ++i) {
                float secondScore;
                float firstScore = i < matchingDocs1.scores().length ? matchingDocs1.scores()[i] : 0.0f;
                float f = secondScore = i < matchingDocs2.scores().length ? matchingDocs2.scores()[i] : 0.0f;
                assert (!(firstScore > 0.0f && secondScore > 0.0f));
                scores[i] = Math.max(firstScore, secondScore);
            }
        }
        DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(matchingDocs1.context().reader().maxDoc());
        try {
            docIdSetBuilder.add(matchingDocs1.bits().iterator());
            docIdSetBuilder.add(matchingDocs2.bits().iterator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        int totalHits = matchingDocs1.totalHits() + matchingDocs2.totalHits();
        return new FacetsCollector.MatchingDocs(matchingDocs1.context(), docIdSetBuilder.build(), totalHits, scores);
    }

    public static FacetsResult search(IndexSearcher searcher, Query q, int n, FacetsCollectorManager fcm) throws IOException {
        return FacetsCollectorManager.doSearch(searcher, null, q, n, null, false, fcm);
    }

    public static FacetsResult search(IndexSearcher searcher, Query q, int n, Sort sort, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, null, q, n, sort, false, fcm);
    }

    public static FacetsResult search(IndexSearcher searcher, Query q, int n, Sort sort, boolean doDocScores, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, null, q, n, sort, doDocScores, fcm);
    }

    public static FacetsResult searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, FacetsCollectorManager fcm) throws IOException {
        return FacetsCollectorManager.doSearch(searcher, after, q, n, null, false, fcm);
    }

    public static FacetsResult searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, after, q, n, sort, false, fcm);
    }

    public static FacetsResult searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, after, q, n, sort, doDocScores, fcm);
    }

    private static FacetsResult doSearch(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, FacetsCollectorManager fcm) throws IOException {
        FacetsCollector facetsCollector;
        TopDocs topDocs;
        int limit = searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        n = Math.min(n, limit);
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        if (n == 0) {
            TotalHitCountCollectorManager hitCountCollectorManager = new TotalHitCountCollectorManager(searcher.getSlices());
            MultiCollectorManager multiCollectorManager = new MultiCollectorManager(hitCountCollectorManager, fcm);
            Object[] result = searcher.search(q, multiCollectorManager);
            topDocs = new TopDocs(new TotalHits(((Integer)result[0]).intValue(), TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
            facetsCollector = (FacetsCollector)result[1];
        } else {
            MultiCollectorManager multiCollectorManager;
            if (sort != null) {
                if (after != null && !(after instanceof FieldDoc)) {
                    throw new IllegalArgumentException("after must be a FieldDoc; got " + String.valueOf(after));
                }
                TopFieldCollectorManager topFieldCollectorManager = new TopFieldCollectorManager(sort, n, (FieldDoc)after, Integer.MAX_VALUE);
                multiCollectorManager = new MultiCollectorManager(topFieldCollectorManager, fcm);
            } else {
                TopScoreDocCollectorManager topScoreDocCollectorManager = new TopScoreDocCollectorManager(n, after, Integer.MAX_VALUE);
                multiCollectorManager = new MultiCollectorManager(topScoreDocCollectorManager, fcm);
            }
            Object[] result = searcher.search(q, multiCollectorManager);
            topDocs = (TopDocs)result[0];
            if (doDocScores) {
                TopFieldCollector.populateScores(topDocs.scoreDocs, searcher, q);
            }
            facetsCollector = (FacetsCollector)result[1];
        }
        return new FacetsResult(topDocs, facetsCollector);
    }

    private static class ReducedFacetsCollector
    extends FacetsCollector {
        ReducedFacetsCollector(Collection<FacetsCollector> facetsCollectors, boolean keepScores) {
            super(keepScores);
            this.getMatchingDocs().addAll(FacetsCollectorManager.reduceMatchingDocs(facetsCollectors));
        }
    }

    public record FacetsResult(TopDocs topDocs, FacetsCollector facetsCollector) {
    }
}

